/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.path;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.fw.rcs.RcsConfig;
import com.ibm.hwmca.fw.rcs.conndata.AccountInfo;
import com.ibm.hwmca.fw.rcs.conndata.AccountingInfo;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.path.InvalidStateException;
import com.ibm.hwmca.fw.rcs.path.PathCancelledException;
import com.ibm.hwmca.fw.rcs.path.PathFailedException;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;

public class TestL2tpPath
extends RcsPath {
    private static final String TRACE_MASKT = "XRCSTAPT";
    private static final String TRACE_MASKF = "XRCSTAPF";
    private static final String TRACE_MASKD = "XRCSTAPD";
    private String ipAddress;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$TestL2tpVpnLink;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$TestL2tpAttLink;

    public TestL2tpPath(PathPlatform platform, LocalizableText text, String ipAddress) {
        this(platform, PathPriority.HIGH, text, ipAddress);
    }

    public TestL2tpPath(PathPriority priority, LocalizableText text, String ipAddress) {
        this(PathPlatform.GENERIC, priority, text, ipAddress);
    }

    public TestL2tpPath(PathPlatform platform, PathPriority priority, LocalizableText text, String ipAddress) {
        super(platform, priority, text);
        this.ipAddress = ipAddress;
        ArrayList<Class> links = new ArrayList<Class>();
        links.add(class$com$ibm$hwmca$fw$rcs$link$TestL2tpVpnLink == null ? (class$com$ibm$hwmca$fw$rcs$link$TestL2tpVpnLink = TestL2tpPath.class$("com.ibm.hwmca.fw.rcs.link.TestL2tpVpnLink")) : class$com$ibm$hwmca$fw$rcs$link$TestL2tpVpnLink);
        links.add(class$com$ibm$hwmca$fw$rcs$link$TestL2tpAttLink == null ? (class$com$ibm$hwmca$fw$rcs$link$TestL2tpAttLink = TestL2tpPath.class$("com.ibm.hwmca.fw.rcs.link.TestL2tpAttLink")) : class$com$ibm$hwmca$fw$rcs$link$TestL2tpAttLink);
        this.setSupportedLinkTypes(links);
    }

    public void open() throws InvalidStateException, PathCancelledException, PathFailedException {
        Trace.trace(TRACE_MASKT, "--> open()");
        RcsConfig.getRcsConfig().setTemporaryConfigValue("l2tp_remote_host", this.ipAddress);
        CustomerInfoData custData = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
        String country = custData.getSystemCountryCode();
        String region = custData.getSystemSubdivisionCode();
        AccountingInfo acctInfo = ConnectionInfoManager.getConnectionInfoManager().getAccountingInfo(this.platform, country, region);
        AccountInfo attInfo = acctInfo.getAccountInfo("Account_URSF");
        if (attInfo == null) {
            String msg = "Accounting information unavailable for " + country + ", " + region;
            Trace.trace(TRACE_MASKF, msg);
            super.close();
            throw new PathFailedException(msg);
        }
        String attAccount = attInfo.getAccount();
        String attUserId = attInfo.getUserId();
        String user = "internet." + attAccount + "." + attUserId;
        RcsConfig.getRcsConfig().setTemporaryConfigValue("att_auth_user", user);
        super.open();
        Trace.trace(TRACE_MASKT, "<-- open()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

